%*********************************************************************%
%                     TEXT TO MATRIX CONVERTER
%   Read the reactions in the text file, and forms a stoichiometric matrix
%*********************************************************************%
clear all

tic
global stoich tp err_coeff
tp = 1;
global depo_metnum_match % stores the counted/processed met. names
                         % to test if any metabolite remains untouched.

[rxnname, rxnlist] = textread('brain_rxnlist_tbmm.txt','%s %s','delimiter',':\t','commentstyle','shell');
rxnlist = strtrim(rxnlist);
format compact
disp(sprintf('\nReaction List was read from the file: %d Reactions',length(rxnlist)) )

for i = 1: length(rxnlist)
[reactant(i), prdct(i)] = strread(rxnlist{i},'%s %s', 'delimiter', '>');
end
reactant = reactant';       prdct = prdct'; 

for i = 1:length(reactant)
reactant{i} = strrep(reactant{i},' -',''); % replace (remove) ' -' and '<-'.
reactant{i} = strrep(reactant{i},'<-','');
end

reactant = strtrim(reactant);
prdct    = strtrim(prdct);
% now, a very good separation of reactants and products was achieved.

%=========================================================
%************   CONSTRUCN OF METABOLITE LIST  ************
%=========================================================
metname = func_metlist(rxnlist);
disp( sprintf('Metabolite List was constructed from reaction list: %d Metabolites', length(metname) ) )

%=========================================================
%************  RXN IRREVERSIBILITY INFO: LB/UB  **********
%=========================================================

%stores the information of rxn reversibility in a binary vector.
j = 1;
for i  = 1:length(rxnlist)
    if length(strfind(rxnlist{i},' -> '))~= 0
        rev_info(i) = 0; % if IRREV
        lb(i) = 0;     ub(i) = inf;
    elseif length(strfind(rxnlist{i}, ' <-> '))~= 0
        rev_info(i) = 1; % if REV
        lb(i) = -inf;  ub(i) = inf;
    else
        hata(j) = i;    j = j + 1;
       % keyboard
    end
end
disp( sprintf(' Number of Irreversible Reactions: %d ',length(find(rev_info == 0)) )  )
disp( sprintf(' Number of Reversible Reactions  : %d ',length(find(rev_info == 1)) )  )

if j > 1
    {'There is an error regarding reaction irreversibility! ...'; 
        'The algorithm will stop...'}
    return
end

stoich = zeros(length(metname), length(rxnlist));

%===================================================================
%************   STOICH. COEFFS OF REACTANTS AND PRODUCTS  **********
%===================================================================
% REACTANTS
%----------
for i = 1:length(reactant) %i.e: = 13. % for REACTANTS
% --------------------------------------------------------------
   if length(strfind(reactant{i}, ' + ')) == 0 %there is ONE reactant
       out1 = reactant{i}; 
      [a,b] = coeff_met(out1,metname,i);
      stoich(a,i) = b;
% -------------------------------------------------------------------------
   else                                                 
      reactant(i) = strrep(reactant(i),' + ',' @ ');                                                                                                  
      out         = strread(reactant{i},'%s','delimiter','@'); % identify the reactants individually

      for nn = 1:length(out)
          [a,b] = coeff_met(out(nn),metname,i);
          stoich(a,i) = b;
      end   
   end

% --------------------------------------------------------------
% PRODUCTS
%---------
   if length(strfind(prdct{i}, ' + ')) == 0 %there is ONE reactant
       out1 = prdct{i}; 
      [a,b] = coeff_met(out1,metname,i);
      stoich(a,i) = -b;

% -------------------------------------------------------------------------
   else                                                 
      prdct(i) = strrep(prdct(i),' + ',' @ ');                                                                                                   
      out = strread(prdct{i},'%s','delimiter','@'); % identify the reactants individually

      for nn = 1:length(out)
      [a,b] = coeff_met(out(nn),metname,i);
      stoich(a,i) = -b;
      end   
   end
end

stoich_sparse = sparse(stoich);
disp(['Reactions were converted into stoichiometric matrix format...'])

disp( sprintf('STOICHIOMETRIC MATRIX SIZE : %d x %d',size(stoich_sparse)))

format loose
toc
